
#include <bur/plctypes.h>

#ifdef _DEFAULT_INCLUDES
	#include <AsDefault.h>
#endif
#include <stdio.h>
#include <string.h>
#include <libemqtt.h>
#include <unistd.h>


#define RCVBUFSIZE 1024
_LOCAL uint8_t packet_buffer[RCVBUFSIZE];
_LOCAL uint8_t send_packet_buffer[RCVBUFSIZE];
_LOCAL mqtt_broker_handle_t broker;
_LOCAL	TcpOpen_typ TcpOpenFub;
_LOCAL	TcpClient_typ TcpClientFub;
_LOCAL	TcpSend_typ TcpSendFub;
_LOCAL	TcpRecv_typ TcpRecvFub;
_LOCAL	TcpClose_typ TcpCloseFub;

_LOCAL	int packet_length;
_LOCAL	uint16_t msg_id, msg_id_rcv;
_LOCAL  uint8_t topic[255], msg[1000];
_LOCAL	uint16_t len;
_LOCAL	int bufLen;
int socket_id;



int send_packet(const void* buf, unsigned int count)
{
	bufLen = 0;
	memset(send_packet_buffer,0,sizeof(send_packet_buffer));
	memcpy(send_packet_buffer,buf,count);
	bufLen = count;
	return 1;
}


void _INIT ProgramInit(void)
{

}

void _CYCLIC ProgramCyclic(void)
{



	mqtt_init(&broker, "avengalvon");
	mqtt_init_auth(&broker, "cid", "campeador");


	broker.send = &send_packet;

	switch (step)

	{
		
		case 5:

			TcpOpenFub.enable = 1;
			TcpOpenFub.pIfAddr = 0;
			TcpOpenFub.options = 0;
			TcpOpenFub.port = 12000;
			TcpOpen(&TcpOpenFub);	
			if (TcpOpenFub.status != 65535)
			{
				if (TcpOpenFub.status == 0)
				{
					broker.socket_info = TcpOpenFub.ident;
					step = 10;
				}	
				else
				{
					step = 255;
				}
			}
			break;

		case 10:
			TcpClientFub.enable  = 1;
			TcpClientFub.ident = TcpOpenFub.ident;
			TcpClientFub.portserv = 1883;
			TcpClientFub.pServer  = (UDINT)&"152.32.240.54";
			TcpClient(&TcpClientFub);
			if (TcpClientFub.status != 65535)
			{
				if (TcpClientFub.status == 0)
				{
					step = 20;
				}	
	
				else
				{
					step = 255;
				}
			}
			break;

		case 20:
			MQTT_Status = 0;
			if (doConnect)
			{	
			// >>>>> CONNECT
				if (mqtt_connect(&broker))
				{
					step = 30;
				}
			}

			if ((doSubscription)&&(MQTT_Connected))
			{	
				// >>>>> SUBSCRIBE
				if (mqtt_subscribe(&broker, "test/topic", &msg_id))
				{
					step = 30;
				}
			}
			if ((doPublish)&&(MQTT_Connected))
			{	
				// >>>>> PUBLISH
				if (mqtt_publish(&broker, "hello/emqtt", testMsg, 0))	
				{
					step = 30;		
					msgCount++;
				}
			}
			if (doDisconnect)
			{	
				// >>>>> DISCONNECT

				doPublish =0;
				doConnect = 0;
				doSubscription = 0;
				MQTT_Connected = 0;
				if (mqtt_disconnect(&broker))
				{
					step = 30;
				}

			}

			break;
		case 30:


			TcpSendFub.enable = 1;
			TcpSendFub.ident = TcpOpenFub.ident;
			TcpSendFub.pData = send_packet_buffer;
			TcpSendFub.datalen = bufLen;
			TcpSendFub.flags = 0;
			TcpSend(&TcpSendFub);
			if (TcpSendFub.status != 65535)
			{
				if (TcpSendFub.status == 0)
				{
					memset(packet_buffer,0,sizeof(packet_buffer));
					if (doConnect || doSubscription || doPublish )
						{step = 40;}	
					else if (doDisconnect)
						{step = 50;}
				}	
	
				else
				{
					step = 50;
				}
			}
			break;

		case 40:

			TcpRecvFub.enable = 1;
			TcpRecvFub.ident = TcpOpenFub.ident;
			TcpRecvFub.flags = 0;
			TcpRecvFub.pData = packet_buffer;
			TcpRecvFub.datamax = sizeof(packet_buffer);
			TcpRecv(&TcpRecvFub);
			if (TcpRecvFub.status != 65535)
			{

				if (TcpRecvFub.status == 0)
				{
					packet_length = TcpRecvFub.recvlen;
	///////////////////////////////жconnectǷɹ//////////////////////////////////////											
					if (doConnect ==1)	
					{
						if(packet_length < 0)
						{
							MQTT_Status = -1;
						}
					
						if(MQTTParseMessageType(packet_buffer) != MQTT_MSG_CONNACK)
						{
							MQTT_Status = -2;
						}
					
						if(packet_buffer[3] != 0x00)
						{
							MQTT_Status =  -2;
						}
						if (MQTT_Status == 0)
						{
							MQTT_Connected = 1;	
							doConnect = 0;
							step = 20;
						}
	
					}
	/////////////////////////////жsubscriptionǷɹ//////////////////////////////////////
					if (doSubscription ==1)	//	
					{
						if(packet_length < 0)
						{
							MQTT_Status = -1;
						}
					
						if(MQTTParseMessageType(packet_buffer) != MQTT_MSG_SUBACK)
						{
							MQTT_Status = -2;
						}
			
						msg_id_rcv = mqtt_parse_msg_id(packet_buffer);
						if(msg_id != msg_id_rcv)
						{			
							MQTT_Status =  -3;
						}
	
						if (MQTT_Status == 0)	
							{doSubscription = 0;}
					}
	/////////////////////////////ʵʱsubscription message//////////////////////////////////////
					if(packet_length == -1)
					{
	
						MQTT_Status =  -1;
					}
					else if(packet_length > 0)
					{
						if(MQTTParseMessageType(packet_buffer) == MQTT_MSG_PUBLISH)
						{
	
							len = mqtt_parse_pub_topic(packet_buffer, topic);
							topic[len] = '\0'; // for printf
							len = mqtt_parse_publish_msg(packet_buffer, msg);
							msg[len] = '\0'; // for printf
							step = 20;
						}
	
					}
	
				}	
				else if (TcpRecvFub.status == 32605)
					timtOut++;
					if (timtOut > 10)
					{
						timtOut = 0;
						step = 20;
					}
				else
				{
					timtOut++;
					if (timtOut > 30)
					{
						timtOut = 0;
						step = 50;
					}
				}
			}
			break;



		case 50:

			// >>>>> DISCONNECT
			TcpCloseFub.enable = 1;
			TcpCloseFub.ident = TcpOpenFub.ident;
			TcpCloseFub.how = 0;
			TcpClose(&TcpCloseFub);
			if (TcpCloseFub.status != 65535)
			{
				if (TcpCloseFub.status == 0)
				{
					step = 0;
					doConnect = 0;
					MQTT_Connected = 0;	
					doPublish = 0;
					doSubscription = 0;
					doDisconnect = 0;
				}	
	
				else
				{
	
				}
			}
			break;

		case 255:
			MQTT_Connected = 0;	
			TcpCloseFub.enable = 1;
			TcpCloseFub.ident = TcpOpenFub.ident;
			TcpCloseFub.how = 0;
			TcpClose(&TcpCloseFub);
			if (TcpCloseFub.status != 65535)
			{
				if (TcpCloseFub.status == 0)
				{
					step = 0;
					doConnect = 0;
					MQTT_Connected = 0;	
					doPublish = 0;
					doSubscription = 0;
					doDisconnect = 0;
				}	
	
				else
				{
	
				}
			}
			break;

	}



}

void _EXIT ProgramExit(void)
{

}

